# -*- coding: utf-8 -*-
"""
Created on Mon Apr 15 13:20:38 2019

@author: Mathijs de Buck (matthijs.debuck@ndcn.ox.ac.uk)
"""

import numpy as np
from matplotlib import pyplot as plt
import matplotlib
import tkinter as tk 
from tkinter import filedialog

font = {'weight' : 'bold',
        'size'   : 20}
matplotlib.rc('font', **font)   

#%% Get filepath from a pop-up window (note: can appear behind current window)
def get_path():
    root = tk.Tk()
    root.withdraw()
    root.focus_force()

    filename = filedialog.askopenfilename()
    filename = filename.replace('/','\\')

    return filename 

#%% Compute the complex conjugate
def compl_conj(array):
    array_T = np.transpose(array)
    return np.conj(array_T)

#%% Importing all Q-matrices + the set of pTx-configurations
file_path_Qs = get_path()
file_path_configs = get_path()

Qs_2D = np.loadtxt(file_path_Qs, dtype=complex)
n_voxels = len(Qs_2D[0,:])
n_channels = np.int16(np.sqrt(len(Qs_2D[:,0])))
print('Q-import completed')

#%% Restoring 3D-shape of Q-matrices set
Qs = np.zeros((n_channels,n_channels,n_voxels),dtype=np.complex64)
for row in range(n_channels):
    Qs[row,:,:] = Qs_2D[row*n_channels:(row+1)*n_channels,:]

#%% Import random configurations
configs = np.loadtxt(file_path_configs, dtype=complex)
n_configs = len(configs[:,0])

#%% Process configs and calculate their maximum SARs
maxSARs = np.zeros(n_configs)

for config_nr in range(n_configs):
    print(config_nr)    #to monitor progress
    configuration = configs[config_nr,:]
    configuration_H = compl_conj(configuration)
    all_SARs = np.zeros(n_voxels)
    for i in range(n_voxels):
        all_SARs[i] = np.real(np.matmul(configuration_H,np.matmul(Qs[:,:,i],configuration)))   #"real" removes minor imaginary components which arise due to discretization
    maxSARs[config_nr] = np.max(all_SARs)
    
#%%
plt.plot(maxSARs)
plt.xlabel('Configuration index')
plt.ylabel('Peak 10gSAR value (W/kg)')